﻿using System;
using System.Text;
using System.Xml;

namespace AHOBPR_Job_Runner.DasXml
{
    [Serializable]
    public class Questionnaire
    {
        public Document Doc { get; set; }
        public Client Client { get; set; }
        public Person Person { get; set; }
        public Facility Facility { get; set; }
        public Attachments Attachments { get; set; }
        public String RegistrantUserId { get; set; }
        public String RegistrantId { get; set; }
         
        public Questionnaire()
        {
            Doc = new Document();
            Client = new Client();
            Person = new Person();
            Facility = new Facility();
            Attachments = new Attachments();
            RegistrantUserId = "";
        }

        public void TestFill()
        {
            Doc.TitleText = "AHOBPR Document Title";
            Doc.AhobprId = new DocumentIdentification() { Id = "THE_AHOBPR_ID", CategoryText = "Questionnaire Response Id", IdentificationSourceText = "AHOBPR" };
            Doc.LoincId = new DocumentIdentification() { Id = "64285-0", CategoryText = "LOINC" };
            Doc.CreationDate = new DateTime(2015, 01, 06, 0, 0, 0);
            Doc.PostDate = new DateTime(2015, 01, 06, 0, 0, 0);

            Client.AssigningAuthority = "2.16.840.1.113883.3.42.10001.100001.12";
            Client.Edipi = "THE_EDIPI";

            Person.BirthDate = new DateTime(1981, 04, 20);
            Person.GivenName = "FRANCIS";
            Person.MiddleName = "";
            Person.Surname = "DAS-FFTEST";
            Person.Sex = "F";
            Person.Ssn = "201501081";
            Person.CurrentMilitarySummary.MilitaryBranchName = "Army";
            Person.QualifyingMilitarySummary.MilitaryBranchName = "Army";

            Facility.Id = "";
            Facility.Jurisdiction = "";
            Facility.Name = "";
        }

        public String Xml{
            get{

                StringBuilder sb = new StringBuilder();
                using (XmlWriter writer = XmlWriter.Create(sb))
                {
                    writer.WriteStartDocument();
                    writer.WriteWhitespace("\r\n");

                    //Main:
                    {
                        writer.WriteStartElement("AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaire");
                        writer.WriteAttributeString("xmlns", "nc", "", @"http://niem.gov/niem/niem-core/2.0");
                        writer.WriteAttributeString("xmlns", "s", "", @"http://niem.gov/niem/structures/2.0");
                        writer.WriteAttributeString("xmlns", "ahobpr", "", @"http://vler.va.gov/vler/schemas/health/clinicalDocuments/historicalData/medicalHistory/AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaires/1.0");
                        writer.WriteAttributeString("xmlns", "vler", "", @"http://va.gov/vler/schemas/vlerSupersetSchema/0.9/vler");
                        writer.WriteAttributeString("xmlns", "xsi", "", @"http://www.w3.org/2001/XMLSchema-instance");
                        writer.WriteAttributeString("xsi", "schemaLocation", "", @"http://vler.va.gov/vler/schemas/health/clinicalDocuments/historicalData/medicalHistory/AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaires/1.0 ../XMLschemas/exchange/AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaire.xsd");
                        writer.WriteWhitespace("\r\n\t");

                        //Document Version:
                        {
                            writer.WriteElementString("ahobpr", "DocumentTypeVersion", "ahobpr", "1.0");
                            writer.WriteWhitespace("\r\n\t");
                        }

                        //Common Data:
                        {
                            writer.WriteStartElement("ahobpr", "CommonData", "ahobpr");
                            writer.WriteWhitespace("\r\n\t\t");

                            //Document:
                            {
                                Doc.GetXml(writer);
                            }

                            //Client:
                            {
                                Client.GetXml(writer);
                            }

                            //Person:
                            {
                                Person.GetXml(writer);
                            }

                            //Facility:
                            {
                                Facility.GetXml(writer);
                            }

                            writer.WriteEndElement();
                            writer.WriteWhitespace("\r\n\t");
                        }

                        //Attachments:
                        {
                            writer.WriteStartElement("ahobpr", "Attachments", "ahobpr");
                            writer.WriteWhitespace("\r\n\t\t");

                            //Attachment:
                            {
                                Attachments.GetXml(writer);
                            }

                            writer.WriteEndElement();
                            writer.WriteWhitespace("\r\n");
                        }

                        writer.WriteEndElement();
                    }
                }

                //Some cleanup to get C#'s XML to look just like the sample XML:
                String xml = sb.ToString();
                xml = xml.Replace("utf-16", "UTF-8");
                xml = xml.Replace("<AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaire", "<ahobpr:AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaire");
                xml = xml.Replace("</AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaire", "</ahobpr:AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaire");
                xml = xml.Replace(" xmlns:nc=\"nc\"", "");
                xml = xml.Replace(" schemaLocation=\"http", " xsi:schemaLocation=\"http");
                xml = xml.Replace(" xmlns:ahobpr=\"ahobpr\"", "");
                xml = xml.Replace("<vler:Client s:id=\"client\" xmlns:s=\"s\" xmlns:vler=\"vler\">", "<vler:Client s:id=\"client\">");
                xml = xml.Replace("<nc:Person s:id=\"p1\" xmlns:s=\"s\">", "<nc:Person s:id=\"p1\">");

                return xml;
            }
        }
    }
}
